/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright        2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUNew.cpp
//
//	Description:
//		Operator new and delete overrides. Always use Photoshop to get
//		your memory.
//
//	Version history:
//		Version 1.0.0	6/29/2000	Created for Photoshop 6.0.
//			Written by Thomas Ruark.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#include "PIUNew.h"



//-------------------------------------------------------------------------------
//
//	operator new
//
// Override operator new so that you use memory that Photoshop has.
//
// NOTE:
// Do not use the new operator from the OS. You will end up fighting with 
// Photoshop for memory and you will lose.
//
//-------------------------------------------------------------------------------
void* operator new(size_t mysize)
{
	void* addr = NULL;
	if (sSPBasic != NULL)
	{
		SPErr error = sSPBasic->AllocateBlock(mysize, &addr);
		if (error)
		{
			addr = NULL;
		}
	}
	return (addr);
}



//-------------------------------------------------------------------------------
//
//	operator new[]
//
// Override operator new so that you use memory that Photoshop has.
//
// NOTE:
// Do not use the new operator from the OS. You will end up fighting with 
// Photoshop for memory and you will lose.
//
//-------------------------------------------------------------------------------
void* operator new[](size_t mysize)
{
	void* addr = NULL;
	if (sSPBasic != NULL)
	{
		SPErr error = sSPBasic->AllocateBlock(mysize, &addr);
		if (error)
		{
			addr = NULL;
		}
	}
	return (addr);
}



//-------------------------------------------------------------------------------
//
//	operator delete
//
// Override operator delete so that you free the memory that Photoshop has.
//
//-------------------------------------------------------------------------------
void operator delete(void* addr)
{
	if (sSPBasic != NULL)
	{
		SPErr error = sSPBasic->FreeBlock(addr);
	}
}



//-------------------------------------------------------------------------------
//
//	operator delete[]
//
// Override operator delete so that you free the memory that Photoshop has.
//
//-------------------------------------------------------------------------------
void operator delete[](void* addr)
{
	if (sSPBasic != NULL)
	{
		SPErr error = sSPBasic->FreeBlock(addr);
	}
}
// end PIUNew.cpp
